/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IBlockRenderProperties;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticle;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticleData;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class BarrelBlock
extends WoodStorageBlockBase {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final VoxelShape ITEM_ENTITY_COLLISION_SHAPE = BarrelBlock.m_49796_((double)0.1, (double)0.1, (double)0.1, (double)15.9, (double)15.9, (double)15.9);

    public BarrelBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, BlockBehaviour.Properties properties) {
        super(properties.m_60955_(), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        level.m_8767_((ParticleOptions)new CustomTintTerrainParticleData(state1, pos), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, 0.15);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(new IBlockRenderProperties(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                if (state.m_60734_() != BarrelBlock.this || !(level instanceof ClientLevel)) {
                    return false;
                }
                ClientLevel clientLevel = (ClientLevel)level;
                VoxelShape voxelshape = state.m_60808_((BlockGetter)level, pos);
                voxelshape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    double d1 = Math.min(1.0, maxX - minX);
                    double d2 = Math.min(1.0, maxY - minY);
                    double d3 = Math.min(1.0, maxZ - minZ);
                    int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                    int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                    int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                    for (int l = 0; l < i; ++l) {
                        for (int i1 = 0; i1 < j; ++i1) {
                            for (int j1 = 0; j1 < k; ++j1) {
                                double d4 = ((double)l + 0.5) / (double)i;
                                double d5 = ((double)i1 + 0.5) / (double)j;
                                double d6 = ((double)j1 + 0.5) / (double)k;
                                double d7 = d4 * d1 + minX;
                                double d8 = d5 * d2 + minY;
                                double d9 = d6 * d3 + minZ;
                                manager.m_107344_(new CustomTintTerrainParticle(clientLevel, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos).updateSprite(state, pos));
                            }
                        }
                    }
                });
                return true;
            }
        });
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).map(b -> {
            ItemStack stackInHand = player.m_21120_(hand);
            if (b.isPacked()) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryPackBlock(player, hand, (WoodStorageBlockEntity)((Object)b), stackInHand)) {
                return InteractionResult.SUCCESS;
            }
            player.m_36220_(Stats.f_12971_);
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(StorageBlockEntity::getDisplayName).orElse(TextComponent.f_131282_)), (BlockPos)pos);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }).orElse(InteractionResult.PASS);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, TICKING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_7820_().m_122424_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        return context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() instanceof ItemEntity ? ITEM_ENTITY_COLLISION_SHAPE : super.m_5939_(state, level, pos, context);
    }

    @Override
    @Nullable
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BarrelBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }
}

